#######################
## SIGNALLING THEORY ##
#######################

model.signaling <- clm(max_prev ~
                               # ethnic hatred
                               epr_ethwar + 
                               # state capacity
                               taxgdp.mwz + 
                               # military coherence
                               troop_quality_log.mwz + 
                               # feminist theory
                               wdi.fertility.mwz + 
                               # democratic peace theory
                               xpolity.mwz + 
                               # signaling
                               nsa.rebstrength.mean +
                               nsa.rebstrength.quadratic.mwz +
                               nsa.effterrcont.mean.mwz +
                               #enemy_max_prev.dummy +
                               #enemy_max_prev_lag.dummy +
                               #ally_max_prev.dummy + 
                               #ally_max_prev_lag.dummy +
                               # control variables
                               duration.mwz +
                               #type_intrastate + type_internationalized + 
                               wdi.pop.density.log.mwz + mountain_log.mwz + 
                               max_prev_lag.dummy,
                             link="logit", data=states.active)

model <- model.signaling
summary(model)
model$nobs # Number of observations
logLik(model)*-2        # -2 log-likelihood
nagelkerke(model$formula, states.active)


model.signaling2 <- clm(max_prev ~
                         # ethnic hatred
                         epr_ethwar + 
                         # state capacity
                         taxgdp.mwz + 
                         # military coherence
                         troop_quality_log.mwz + 
                         # feminist theory
                         wdi.fertility.mwz + 
                         # democratic peace theory
                         xpolity.mwz + 
                         # signaling
                         enemy_max_prev.dummy +
                         enemy_max_prev_lag.dummy +
                         ally_max_prev.dummy + 
                         ally_max_prev_lag.dummy +
                         max_prev_lag.dummy +
                         # control variables
                         max_prev_lag.dummy +
                         duration.mwz +
                         #type_intrastate + type_internationalized + 
                         wdi.pop.density.log.mwz + mountain_log.mwz,
                       link="logit", data=states.active)

model <- model.signaling2
summary(model)
model$nobs # Number of observations
logLik(model)*-2        # -2 log-likelihood
nagelkerke(model$formula, states.active)
